<?php
require_once '../config.php';

if(!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Please login first']);
    exit();
}

if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['order_id'])) {
    $order_id = (int)$_POST['order_id'];
    $user_id = $_SESSION['user_id'];
    
    // Get order details
    $stmt = $conn->prepare("SELECT o.*, p.name as product_name FROM orders o JOIN products p ON o.product_id = p.id WHERE o.id = ? AND o.user_id = ?");
    $stmt->bind_param("ii", $order_id, $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows == 0) {
        echo json_encode(['success' => false, 'message' => 'Order not found']);
        exit();
    }
    
    $order = $result->fetch_assoc();
    
    // Check if order can be cancelled (only pending orders can be cancelled)
    if($order['status'] != 'pending') {
        echo json_encode(['success' => false, 'message' => 'Only pending orders can be cancelled']);
        exit();
    }
    
    // Get reason and notes
    $reason = isset($_POST['reason']) ? sanitize($_POST['reason']) : 'Not specified';
    $notes = isset($_POST['notes']) ? sanitize($_POST['notes']) : '';
    
    // Start transaction
    $conn->begin_transaction();
    
    try {
        // Update order status
        $update_stmt = $conn->prepare("UPDATE orders SET status = 'cancelled', updated_at = NOW() WHERE id = ?");
        $update_stmt->bind_param("i", $order_id);
        $update_stmt->execute();
        
        // Refund amount to user balance
        $conn->query("UPDATE users SET balance = balance + {$order['amount']} WHERE id = $user_id");
        
        // Record refund transaction
        $description = "Order cancellation refund - Order #$order_id - Reason: $reason";
        if(!empty($notes)) {
            $description .= " - Notes: $notes";
        }
        
        $conn->query("INSERT INTO transactions (user_id, type, amount, description, status) 
                      VALUES ($user_id, 'deposit', {$order['amount']}, '$description', 'completed')");
        
        // Send notification to admin
        $admin_notification = "Order #$order_id cancelled by {$order['customer_name']} - Product: {$order['product_name']} - Amount: ৳{$order['amount']}";
        $conn->query("INSERT INTO admin_notifications (message, type) VALUES ('$admin_notification', 'order_cancelled')");
        
        $conn->commit();
        
        echo json_encode(['success' => true, 'message' => 'Order cancelled successfully. Amount refunded to your balance.']);
    } catch (Exception $e) {
        $conn->rollback();
        echo json_encode(['success' => false, 'message' => 'Failed to cancel order. Please try again.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>